/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateArmorColors {
    private final int[][] cols = new int[4][2];
    private final int eyepiece;

    public PacketUpdateArmorColors() {
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            ItemStack stack = ClientUtils.getClientPlayer().m_6844_(slot);
            if (!(stack.m_41720_() instanceof PneumaticArmorItem)) continue;
            this.cols[slot.m_20749_()][0] = ((PneumaticArmorItem)stack.m_41720_()).m_41121_(stack);
            this.cols[slot.m_20749_()][1] = ((PneumaticArmorItem)stack.m_41720_()).getSecondaryColor(stack);
        }
        ItemStack stack = ClientUtils.getClientPlayer().m_6844_(EquipmentSlot.HEAD);
        this.eyepiece = stack.m_41720_() instanceof PneumaticArmorItem ? ((PneumaticArmorItem)stack.m_41720_()).getEyepieceColor(stack) : 0;
    }

    public PacketUpdateArmorColors(FriendlyByteBuf buffer) {
        for (int i = 0; i < 4; ++i) {
            this.cols[i][0] = buffer.readInt();
            this.cols[i][1] = buffer.readInt();
        }
        this.eyepiece = buffer.readInt();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        for (int i = 0; i < 4; ++i) {
            buffer.writeInt(this.cols[i][0]);
            buffer.writeInt(this.cols[i][1]);
        }
        buffer.writeInt(this.eyepiece);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                    ItemStack stack = player.m_6844_(slot);
                    if (!(stack.m_41720_() instanceof PneumaticArmorItem)) continue;
                    ((PneumaticArmorItem)stack.m_41720_()).m_41115_(stack, this.cols[slot.m_20749_()][0]);
                    ((PneumaticArmorItem)stack.m_41720_()).setSecondaryColor(stack, this.cols[slot.m_20749_()][1]);
                }
                ItemStack stack = player.m_6844_(EquipmentSlot.HEAD);
                if (stack.m_41720_() instanceof PneumaticArmorItem) {
                    ((PneumaticArmorItem)stack.m_41720_()).setEyepieceColor(stack, this.eyepiece);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

